/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.file;

import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.file.CmdDataSelector;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class FileSelectDlg
extends JDialog {
    private static final String LAST_OPEN_PATH_KEY = "open_path";
    private static final String LAST_SAVE_PATH_KEY = "save_path";
    private boolean m_openNotSave;
    private boolean m_remoteOnly = false;
    private JTabbedPane m_tabs;
    private JFileChooser m_localChooser;
    private CmdDataSelector m_remoteChooser;
    private boolean m_localChoosen = false;
    private boolean m_canceled = true;
    private boolean firstTime = true;

    public FileSelectDlg(JFrame jFrame, boolean bl, boolean bl2, FmtFileType fmtFileType, InstrumentSource instrumentSource) {
        super((Frame)jFrame, true);
        this.m_openNotSave = bl;
        this.setTitle(this.m_openNotSave ? "Open File..." : "Save File...");
        this.m_tabs = new QDTabbedPane();
        if (!bl2) {
            this.m_tabs.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (FileSelectDlg.this.m_tabs.getSelectedIndex() == 1 && FileSelectDlg.this.firstTime) {
                        FileSelectDlg.this.firstTime = false;
                        FileSelectDlg.this.m_remoteChooser.activated();
                    }
                }
            });
        }
        Preferences preferences = Preferences.userNodeForPackage(FileSelectDlg.class);
        String string = preferences.get(this.m_openNotSave ? LAST_OPEN_PATH_KEY : LAST_SAVE_PATH_KEY, "");
        this.m_localChooser = new JFileChooser();
        if (string.length() > 0) {
            this.m_localChooser.setCurrentDirectory(new File(string));
        }
        this.m_localChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equalsIgnoreCase("ApproveSelection")) {
                    FileSelectDlg.this.m_localChoosen = true;
                    FileSelectDlg.this.approved();
                } else if (string.equalsIgnoreCase("CancelSelection")) {
                    FileSelectDlg.this.m_localChoosen = true;
                    FileSelectDlg.this.canceled();
                }
            }
        });
        this.m_localChooser.setDialogType(this.m_openNotSave ? 0 : 1);
        this.m_localChooser.setFileSelectionMode(0);
        if (this.m_openNotSave || fmtFileType == FmtFileType.REPORT) {
            this.m_localChooser.addChoosableFileFilter(new TypeFilter("Format Report Files", FmtFileType.REPORT));
        }
        if (this.m_openNotSave || fmtFileType == FmtFileType.MENU) {
            this.m_localChooser.addChoosableFileFilter(new TypeFilter("Source Menu Files", FmtFileType.MENU));
        }
        if (this.m_openNotSave || fmtFileType == FmtFileType.FORMAT) {
            this.m_localChooser.addChoosableFileFilter(new TypeFilter("Format Files", FmtFileType.FORMAT));
        }
        if (fmtFileType == FmtFileType.HTML) {
            this.m_localChooser.addChoosableFileFilter(new TypeFilter("HTML Files", FmtFileType.HTML));
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.m_localChooser, "Center");
        this.m_tabs.addTab("Local", jPanel);
        if (!bl2) {
            this.m_remoteChooser = new CmdDataSelector(fmtFileType, this.m_openNotSave, instrumentSource);
            this.m_remoteChooser.setActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getID() == 1) {
                        FileSelectDlg.this.approved();
                    } else {
                        FileSelectDlg.this.canceled();
                    }
                }
            });
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)((Object)this.m_remoteChooser), "Center");
            this.m_tabs.addTab("Remote", jPanel);
        }
        this.getContentPane().setBackground(QDStdUI.getBackground());
        this.getContentPane().add(this.m_tabs);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public boolean isOpenDialog() {
        return this.m_openNotSave;
    }

    public boolean wasCanceled() {
        return this.m_canceled;
    }

    public boolean wasLocalChoosen() {
        return this.m_localChoosen;
    }

    public void hideLocal() {
        if (this.m_tabs.getTabCount() != 2) {
            MsgLog.error("Internal Error: hideLocal not allowed");
            return;
        }
        this.m_tabs.removeTabAt(0);
        this.m_remoteOnly = true;
    }

    public void setVisible(boolean bl) {
        if (bl && this.m_remoteOnly && this.firstTime) {
            this.firstTime = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FileSelectDlg.this.m_remoteChooser.activated();
                }
            });
        }
        super.setVisible(bl);
    }

    public void setFileName(String string, boolean bl) {
        if (string.length() != 0) {
            File file = new File(string);
            if (bl) {
                this.m_localChooser.setSelectedFile(file);
                if (this.m_remoteChooser != null) {
                    this.m_remoteChooser.setFileName(file.getName());
                }
            } else {
                if (this.m_remoteChooser != null) {
                    this.m_remoteChooser.setFileName(file.getName());
                }
                this.m_localChooser.setSelectedFile(new File(file.getName()));
            }
        }
    }

    public void setLocalFileName(String string) {
        if (string.length() != 0) {
            File file = new File(string);
            this.m_localChooser.setSelectedFile(file);
        }
    }

    public void setRemoteFileName(String string) {
        if (string.length() != 0) {
            File file = new File(string);
            if (this.m_remoteChooser != null) {
                this.m_remoteChooser.setFileName(file.getName());
            }
        }
    }

    public FmtFileType getFileType() {
        FmtFileType fmtFileType = FmtFileType.FORMAT;
        if (this.m_localChoosen) {
            File file = this.m_localChooser.getSelectedFile();
            if (file != null) {
                String string = file.getName().toLowerCase();
                for (FmtFileType fmtFileType2 : FmtFileType.values()) {
                    if (!string.endsWith(fmtFileType2.extension())) continue;
                    fmtFileType = fmtFileType2;
                    break;
                }
            }
        } else if (this.m_remoteChooser != null) {
            fmtFileType = this.m_remoteChooser.getSelectedType();
        }
        return fmtFileType;
    }

    public File getLocalFile() {
        File file = null;
        if (this.m_localChoosen) {
            file = this.m_localChooser.getSelectedFile();
        }
        return file;
    }

    public String getRemoteFileName() {
        String string = null;
        if (!this.m_localChoosen && this.m_remoteChooser != null) {
            string = this.m_remoteChooser.getFileName();
        }
        return string;
    }

    public String getFileName() {
        String string;
        if (this.wasLocalChoosen()) {
            File file = this.getLocalFile();
            if (file == null) {
                return "";
            }
            string = file.getAbsolutePath();
        } else {
            string = this.getRemoteFileName();
            if (string == null) {
                return "";
            }
        }
        return string;
    }

    public boolean fileExists() {
        if (this.wasLocalChoosen()) {
            File file = this.getLocalFile();
            if (file == null) {
                return false;
            }
            return file.exists();
        }
        if (this.m_remoteChooser != null) {
            return this.m_remoteChooser.fileExists();
        }
        return false;
    }

    private void approved() {
        if (this.m_localChoosen) {
            Preferences preferences = Preferences.userNodeForPackage(FileSelectDlg.class);
            String string = this.m_localChooser.getCurrentDirectory().getAbsolutePath();
            preferences.put(this.m_openNotSave ? LAST_OPEN_PATH_KEY : LAST_SAVE_PATH_KEY, string);
        }
        this.m_canceled = false;
        this.setVisible(false);
    }

    private void canceled() {
        this.m_canceled = true;
        this.setVisible(false);
    }

    private class TypeFilter
    extends FileFilter {
        private FmtFileType m_type;
        private String m_descr;

        public TypeFilter(String string, FmtFileType fmtFileType) {
            this.m_type = fmtFileType;
            this.m_descr = string;
        }

        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return string.endsWith(this.m_type.extension()) || file.isDirectory();
        }

        public String getDescription() {
            return this.m_descr + " (" + this.m_type.extension() + ")";
        }
    }
}

